% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation.R
\name{correlation-functions}
\alias{correlation-functions}
\alias{cor}
\title{NA-aware Correlation Function}
\usage{
cor(
  x,
  y = NULL,
  use = "pairwise.complete.obs",
  method = c("pearson", "kendall", "spearman"),
  ...
)
}
\arguments{
\item{x}{A numeric vector, matrix, or data frame.}

\item{y}{Optional. A numeric vector, matrix, or data frame.}

\item{use}{Method for handling missing values.
Default \code{"pairwise.complete.obs"}.}

\item{method}{Correlation method: "pearson", "kendall", or "spearman".}

\item{...}{Additional arguments passed to \code{stats::cor()}.}
}
\value{
A correlation matrix or single correlation coefficient.
}
\description{
Drop-in replacement for \code{cor()} that defaults to
\code{use = "pairwise.complete.obs"}.
}
\examples{
x <- c(1, 2, NA, 4)
y <- c(2, 4, 6, 8)
cor(x, y)

}
