% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/answer_using_r.R
\name{answer_using_r}
\alias{answer_using_r}
\title{Enable LLM to draft and execute R code}
\usage{
answer_using_r(
  prompt,
  add_text = "You must code in the programming language 'R' to answer this prompt.",
  pkgs_to_use = c(),
  objects_to_use = list(),
  list_packages = TRUE,
  list_objects = TRUE,
  skim_dataframes = TRUE,
  evaluate_code = FALSE,
  r_session_options = list(),
  output_as_tool = FALSE,
  return_mode = c("full", "code", "console", "object", "formatted_output", "llm_answer")
)
}
\arguments{
\item{prompt}{A single string or a \code{\link[=tidyprompt]{tidyprompt()}} object}

\item{add_text}{Single string which will be added to the prompt text,
informing the LLM that they must code in R to answer the prompt}

\item{pkgs_to_use}{A character vector of package names that may be used
in the R code that the LLM will generate. If evaluating the R code, these
packages will be pre-loaded in the R session}

\item{objects_to_use}{A named list of objects that may be used in the R code
that the LLM will generate. If evaluating the R code, these objects will be pre-loaded
in the R session. The names of the list will be used as the object names in the
R session}

\item{list_packages}{Logical indicating whether the LLM should be informed
about the packages that may be used in their R code (if TRUE, a list of the
loaded packages will be shown in the initial prompt)}

\item{list_objects}{Logical indicating whether the LLM should be informed
about the existence of 'objects_to_use' (if TRUE, a list of the objects
plus their types will be shown in the initial prompt)}

\item{skim_dataframes}{Logical indicating whether the LLM should be informed
about the structure of dataframes present in 'objects_to_use' (if TRUE,
a skim summary of each \code{data.frame} type object will be shown in the initial prompt).
This uses the function \code{\link[=skim_with_labels_and_levels]{skim_with_labels_and_levels()}}}

\item{evaluate_code}{Logical indicating whether the R code should be
evaluated. If TRUE, the R code will be evaluated in a separate R session
(using 'callr' to create an isolated R session via \link[callr]{r_session}).
Note that setting this to 'TRUE' means that code generated by the LLM will
run on your system; use this setting with caution}

\item{r_session_options}{A list of options to pass to the \link[callr]{r_session}.
This can be used to customize the R session. See \link[callr]{r_session_options}
for the available options. If no options are provided, the default options
will be used but with 'system_profile' and 'user_profile' set to FALSE}

\item{output_as_tool}{Logical indicating whether the console output of the
evaluated R code should be sent back to the LLM, meaning the LLM will use
R code as a tool to formulate a final answer to the prompt. If TRUE, the LLM
can decide if they can answer the prompt with the output, or if they need to modify
their R code. Once the LLM does not provide new R code (i.e., the prompt is being answered)
this prompt wrap will end (it will continue for as long as the LLM provides R code).
When this option is enabled, the resulting \code{\link[=prompt_wrap]{prompt_wrap()}} will be of type 'tool'.
If TRUE, the return mode will also always be set to 'llm_answer'}

\item{return_mode}{Single string indicating the return mode. One of:
\itemize{
\item 'full': Return a list with the final LLM answer, the extracted R code,
and (if argument 'evaluate_code' is TRUE) the output of the R code
\item 'code': Return only the extracted R code
\item 'console': Return only the console output of the evaluated R code
\item 'object': Return only the object produced by the evaluated R code
\item 'formatted_output': Return a formatted string with the extracted R code
and its console output, and a print of the last object (this is identical to how it would
be presented to the LLM if 'output_as_tool' is TRUE)
\item 'llm_answer': Return only the final LLM answer
}
When choosing 'console' or 'object', an additional instruction will be added to
the prompt text to inform the LLM about the expected output of the R code.
If 'output_as_tool' is TRUE, the return mode will always be set to 'llm_answer'
(as the LLM will be using the R code as a tool to answer the prompt)}
}
\value{
A \code{\link[=tidyprompt]{tidyprompt()}} object with the \code{\link[=prompt_wrap]{prompt_wrap()}} added to it, which
will handle R code generation and possibly evaluation
}
\description{
This function adds a prompt wrap to a \code{\link[=tidyprompt]{tidyprompt()}} that instructs the
LLM to answer the prompt with R code. There are various options to customize
the behavior of this prompt wrap, concerning the evaluation of the R code,
the packages that may be used, the objects that already exist in the R
session, and if the console output that should be sent back to the LLM.
}
\details{
For the evaluation of the R code, the 'callr' package is required.
Please note: automatic evaluation of generated R code may be dangerous to your
system; you must use this function with caution.
}
\examples{
\dontrun{
  # Prompt to value calculated with R
  avg_miles_per_gallon <- paste0(
    "Using my data,",
    " calculate the average miles per gallon (mpg) for cars with 6 cylinders."
  ) |>
    answer_as_integer() |>
    answer_using_r(
      pkgs_to_use = c("dplyr"),
      objects_to_use = list(mtcars = mtcars),
      evaluate_code = TRUE,
      output_as_tool = TRUE
    ) |>
    send_prompt()
  avg_miles_per_gallon

  # Prompt to linear model object in R
  model <- paste0(
    "Using my data, create a statistical model",
    " investigating the relationship between two variables."
  ) |>
    answer_using_r(
      objects_to_use = list(data = mtcars),
      evaluate_code = TRUE,
      return_mode = "object"
    ) |>
    prompt_wrap(
      validation_fn = function(x) {
        if (!inherits(x, "lm"))
          return(llm_feedback("The output should be a linear model object."))
        return(x)
      }
    ) |>
    send_prompt()
  summary(model)

  # Prompt to plot object in R
  plot <- paste0(
    "Create a scatter plot of miles per gallon (mpg) versus",
    " horsepower (hp) for the cars in my data.",
    " Use different colors to represent the number of cylinders (cyl).",
    " Be very creative and make the plot look nice but also a little crazy!"
  ) |>
    answer_using_r(
      pkgs_to_use = c("ggplot2"),
      objects_to_use = list(mtcars = mtcars),
      evaluate_code = TRUE,
      return_mode = "object"
    ) |>
    send_prompt()
  plot
}
}
\seealso{
\code{\link[=answer_using_tools]{answer_using_tools()}}

Other pre_built_prompt_wraps: 
\code{\link{add_image}()},
\code{\link{add_text}()},
\code{\link{answer_as_boolean}()},
\code{\link{answer_as_category}()},
\code{\link{answer_as_integer}()},
\code{\link{answer_as_json}()},
\code{\link{answer_as_list}()},
\code{\link{answer_as_multi_category}()},
\code{\link{answer_as_named_list}()},
\code{\link{answer_as_regex_match}()},
\code{\link{answer_as_text}()},
\code{\link{answer_by_chain_of_thought}()},
\code{\link{answer_by_react}()},
\code{\link{answer_using_sql}()},
\code{\link{answer_using_tools}()},
\code{\link{prompt_wrap}()},
\code{\link{quit_if}()},
\code{\link{set_system_prompt}()}

Other answer_using_prompt_wraps: 
\code{\link{answer_using_sql}()},
\code{\link{answer_using_tools}()}
}
\concept{answer_using_prompt_wraps}
\concept{pre_built_prompt_wraps}
