% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{sna}
\alias{sna}
\title{Build a Social Network Analysis Model}
\usage{
sna(x, aggregate = sum, ...)
}
\arguments{
\item{x}{A \code{data.frame} or a \code{matrix} with three columns: the first two
representing the states and the third giving the weights.}

\item{aggregate}{A \code{function} to use for aggregating the weights. The
default is \code{\link[=sum]{sum()}}.}

\item{...}{Additional arguments passed to \code{aggregate}.}
}
\value{
A \code{tna} object representing the model.
}
\description{
Build a Social Network Analysis Model
}
\examples{
set.seed(123)
d <- data.frame(
  from = sample(LETTERS[1:4], 100, replace = TRUE),
  to = sample(LETTERS[1:4], 100, replace = TRUE),
  weight = rexp(100)
)
model <- sna(d)

}
