% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tseffects.R
\name{pulse.calculator}
\alias{pulse.calculator}
\title{Generate pulse effect formulae for a given autoregressive distributed lag (ADL) model}
\usage{
pulse.calculator(x.vrbl, y.vrbl = NULL, limit)
}
\arguments{
\item{x.vrbl}{a named vector of the x variables and corresponding lag orders in an ADL model}

\item{y.vrbl}{a named vector of the (lagged) y variables and corresponding lag orders in an ADL model}

\item{limit}{an integer for the number of periods (s) to determine the pulse effect (beginning at 0)}
}
\value{
a list of limit + 1 \code{mpoly} formulae containing the pulse effect formula in each period
}
\description{
Generate pulse effect formulae for a given autoregressive distributed lag (ADL) model
}
\details{
\code{pulse.calculator} does no calculation. It generates a list of \code{mpoly} formulae that contain variable names that represent the pulse effect in each period. The expectation is that these will be evaluated using coefficients from an object containing an ADL model with corresponding variables. Note: \code{mpoly} does not allow variable names with a .; variables passed to \code{pulse.calculator} should not include this character
}
\examples{
# ADL(1,1)
x.lags <- c("x" = 0, "l_1_x" = 1) # lags of x
y.lags <- c("l_1_y" = 1)
s <- 5
pulses <- pulse.calculator(x.vrbl = x.lags, y.vrbl = y.lags, limit = s)
pulses
# Will also handle finite dynamics
x.lags <- c("x" = 0, "l_1_x" = 1) # lags of x
finite.pulses <- pulse.calculator(x.vrbl = x.lags, limit = s)
}
\author{
Soren Jordan, Garrett N. Vande Kamp, and Reshi Rajan
}
\keyword{utilities}
