% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_row.R
\name{tt_row}
\alias{tt_row}
\title{Style specific rows}
\usage{
tt_row(
  table,
  row,
  bold = NULL,
  italic = NULL,
  color = NULL,
  fill = NULL,
  align = NULL,
  font_size = NULL,
  rotate = NULL,
  inset = NULL,
  stroke = NULL,
  hline_above = NULL,
  hline_below = NULL
)
}
\arguments{
\item{table}{A \code{typst_table} object.}

\item{row}{Integer vector of row numbers to style. Use 0 for the header row,
1 to n for data rows. Use negative indices to target \code{tt_header_above()} rows:
-1 is the innermost header_above (closest to the main header), -2 is the next
row up, etc.}

\item{bold}{Logical. Make text bold.}

\item{italic}{Logical. Make text italic.}

\item{color}{Text color.}

\item{fill}{Fill color.}

\item{align}{Row alignment override.}

\item{font_size}{Font size.}

\item{rotate}{Rotation angle (e.g., \code{"90deg"}, \code{90}, \code{"1.5rad"}).}

\item{inset}{Cell padding (e.g., \code{"10pt"}, \code{"5pt 8pt"}).}

\item{stroke}{Stroke (border) specification for the cell(s). Can be \code{TRUE} for
default 1pt black, a color, a Typst stroke spec like \code{"2pt + blue"}, or a
Typst dictionary like \code{"(bottom: 1pt)"}.}

\item{hline_above}{Add horizontal line above the row. Can be \code{TRUE} for default
line or a stroke specification.}

\item{hline_below}{Add horizontal line below the row.}
}
\value{
The modified \code{typst_table} object.
}
\description{
Applies formatting to one or more rows. Use row = 0 to style the header row.
}
\examples{
# Style header row
tt(mtcars[1:5, 1:3], rownames = FALSE) |>
  tt_row(0, bold = TRUE, fill = "gray")

# Highlight specific rows
tt(mtcars[1:5, 1:3], rownames = FALSE) |>
  tt_row(c(1, 3, 5), fill = "#ffffcc")

# Add horizontal lines
tt(mtcars[1:5, 1:3], rownames = FALSE) |>
  tt_row(3, hline_above = TRUE, hline_below = TRUE)

}
