% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_indeces.R
\name{calc_pielou_evenness}
\alias{calc_pielou_evenness}
\title{Calculate Pielou's Evenness}
\usage{
calc_pielou_evenness(mf, magnitude)
}
\arguments{
\item{mf}{Character vector. A list of unique molecular formulas.}

\item{magnitude}{Numeric vector. A list of respective intensities (abundances) for each molecular formula.
Must be non-negative and have the same length as \code{mf}.}
}
\value{
A single numeric value representing Pielou's evenness.
}
\description{
This function calculates Pielou's evenness index, a measure of the distribution of abundances across
molecular formulas. Evenness ranges from 0 (one molecular formula dominates) to 1 (all formulas are equally abundant).

Evenness is derived using the Shannon index:
\deqn{E = \frac{H}{\log(S)}}
where:
\itemize{
\item \eqn{H} is the Shannon diversity index.
\item \eqn{S} is the number of unique molecular formulas.
}

If there is only one molecular formula, evenness is defined as 1.
}
\examples{
calc_pielou_evenness(
  mf = c("C10H20O5", "C12H18O3", "C18H30O6"),
  magnitude = c(1982375, 2424, 312410)
)
}
