% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_recalibrate_ms.R
\name{calc_recalibrate_ms}
\alias{calc_recalibrate_ms}
\title{Recalibrate mass spectra}
\usage{
calc_recalibrate_ms(
  pl,
  col_spectrum_id = "file_id",
  calibr_list = c("cal_fa_neg", "cal_marine_dom_neg", "calibration", "marine_dom",
    "cal_marine_dom_pos", "cal_marine_pw_neg", "cal_SRFA_neg", "cal_SRFA_OL_neg",
    "E_coli_metabolome", "Post-column standard"),
  custom_calibr_list = NULL,
  min_no_calibrants = 1,
  outlier_removal = TRUE,
  insufficient_calibrants = c("extrapolate", "remove_spectrum"),
  verbose = FALSE,
  pol = c("neg", "pos", "neutral"),
  ma_dev,
  ...
)
}
\arguments{
\item{pl}{data.table containing peak data. Mandatory columns include neutral
molecular mass (\code{mass}), peak magnitude (\code{i_magnitude}), and a peak
identifier (\code{peak_id}).}

\item{col_spectrum_id}{Character. Name of the column that identifies individual
spectra or samples (default: \code{"file_id"}). The peaklist must also contain a
column named \code{"mass"}.}

\item{calibr_list}{Character string. Name of a predefined calibrant list stored in
\code{ume::known_mf} (column \code{category}). Ignored if \code{custom_calibr_list} is provided.}

\item{custom_calibr_list}{Character vector. Custom list of molecular formulas to
be used as calibrants instead of a predefined list.}

\item{min_no_calibrants}{Integer. Minimum number of calibrant peaks required per
spectrum to perform recalibration (default: 3). If fewer calibrants are found,
recalibration is skipped or handled according to \code{insufficient_calibrants}.}

\item{outlier_removal}{Logical. If \code{TRUE} (default), mass-accuracy-based outlier
detection is applied to the calibrants within each spectrum before recalibration.}

\item{insufficient_calibrants}{Character. Defines how spectra with too few
calibrants are handled:
\describe{
\item{\code{"extrapolate"}}{Apply the median calibration slope and intercept from
spectra with at least two calibrants (default).}
\item{\code{"remove_spectrum"}}{Remove spectra for which no calibrant peaks were
identified.}
}}

\item{verbose}{logical; if \code{TRUE}, show progress messages.}

\item{...}{
  Arguments passed on to \code{\link[=assign_formulas]{assign_formulas}}, \code{\link[=calc_neutral_mass]{calc_neutral_mass}}, \code{\link[=calc_ma_abs]{calc_ma_abs}}
  \describe{
    \item{\code{formula_library}}{Molecular formula library: a predefined data.table used for
assigning molecular formulas to a peak list and for mass calibration. The library
requires a fixed format, including mass values for matching. Predefined libraries
are available in the R package \emph{ume.formulas} and further described in
Leefmann et al. (2019). A standard library for marine dissolved organic matter is
\code{ume.formulas::lib_02}. New libraries can be built using
\code{ume::create_ume_formula_library()}.}
    \item{\code{mz}}{Numeric vector of m/z values (> 0).}
    \item{\code{pol}}{Character: \code{"neg"}, \code{"pos"}, or \code{"neutral"}.}
    \item{\code{m}}{Measured mass}
    \item{\code{ma_dev}}{Mass accuracy in +/- parts per million (ppm)}
  }}
}
\value{
A list containing:
\describe{
\item{\code{pl}}{Recalibrated peaklist.}
\item{\code{check}}{Summary of the number of calibrants per spectrum.}
\item{\code{cal_peaks}}{Assigned calibrant peaks and recalibration results.}
\item{\code{cal_stats}}{Calibration statistics (slopes, intercepts, accuracy metrics).}
\item{\verb{fig_*}}{Interactive \pkg{plotly} figures comparing mass accuracy
before and after recalibration.}
}
}
\description{
This function performs an automated mass recalibration for peak lists using
predefined or user-specified calibrant lists.

Calibration can be based on existing calibrant tables included in \code{ume::known_mf}
(via the \code{calibr_list} argument) or on a user-provided set of molecular formulas
(\code{custom_calibr_list}).

The function assigns calibrant peaks to each spectrum and evaluates their
mass accuracy. Three independent outlier tests are applied to the assigned
calibrants, and only those that pass all tests are used to calculate the
recalibration model.

Recalibration is performed using a linear model (\code{m ~ m_cal}), and spectra with
insufficient calibrant matches can be either excluded or corrected using
extrapolated calibration parameters.
}
\details{
Recalibration is based on a linear fit (\code{lm(m ~ m_cal)}), with slopes and intercepts
computed individually for each spectrum. Optionally, spectra without sufficient
calibrants can be corrected using median calibration parameters derived from
other spectra.
}
\seealso{
Other calculations: 
\code{\link{calc_data_summary}()},
\code{\link{calc_dbe}()},
\code{\link{calc_eval_params}()},
\code{\link{calc_exact_mass}()},
\code{\link{calc_ideg}()},
\code{\link{calc_ma}()},
\code{\link{calc_neutral_mass}()},
\code{\link{calc_nm}()},
\code{\link{calc_norm_int}()},
\code{\link{calc_number_assignment}()},
\code{\link{calc_number_occurrence}()}
}
\author{
Boris P. Koch
}
\concept{calculations}
\keyword{internal}
