% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color.palette.R
\name{color.palette}
\alias{color.palette}
\title{Create a Custom Interpolated Color Palette}
\usage{
color.palette(steps, n.steps.between = NULL, ...)
}
\arguments{
\item{steps}{A character vector of base colors (e.g., hex codes or color names).
These colors define the breakpoints in the palette.}

\item{n.steps.between}{An optional integer vector specifying how many interpolated colors should
be added \strong{between} each pair of entries in \code{steps}.
Must have length \code{length(steps) - 1}.
If \code{NULL} (default), no intermediate colors are added beyond the endpoints.}

\item{...}{Additional arguments passed to methods.}
}
\value{
A function of class \code{"colorRampPalette"} that generates interpolated color
vectors when called with a single integer argument \code{n}.

For example, \verb{pal <- color.palette(c("blue", "white", "red")); pal(100)}
returns a vector of 100 smoothly interpolated colors.
}
\description{
Constructs a continuous color palette from a sequence of base colors.
Intermediate colors are interpolated between each pair of adjacent colors,
optionally using a custom number of interpolation steps.
}
\details{
This helper is primarily used for UME visualizations (e.g., color bars in
density plots), but it can be used independently for any plotting task.
}
\examples{
# Generate a simple blue-white-red palette
pal <- color.palette(c("blue", "white", "red"))
pal(10)

# Add additional steps between colors
pal2 <- color.palette(c("blue", "white", "red"), n.steps.between = c(5, 10))
pal2(20)

}
