% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{order_columns}
\alias{order_columns}
\title{Order columns}
\usage{
order_columns(mfd, col_order = NULL, ...)
}
\arguments{
\item{mfd}{data.table with molecular formula data as derived from
\code{ume::assign_formulas}. Column names of elements/isotopes must match names in
the \code{isotope} column of \code{ume::masses}; values are integers representing
counts per formula.}

\item{col_order}{A list of column names that defines the order of columns of mfd. Default is:
cols = c("sample_tag", "sample_id", "file", "file_id", "peak_id", "i_magnitude", "norm_int", "m", "m_cal", "ppm", "nm", "mf", "dbe",
"c", "h", "n", "o", "p", "s", "hc", "oc", "nc", "sc", "ai", "z", "kmd")
If "cols" is NULL the default order is applied.}

\item{...}{Additional arguments passed to methods.}
}
\value{
A data.table containing isotope data for those isotopes present in mfd.
}
\description{
Take most prominent columns required for data evaluation first - followed by all other columns.
}
\examples{
order_columns(mfd = mf_data_demo)
}
\seealso{
Other tools: 
\code{\link{add_missing_element_columns}()}
}
\concept{tools}
\keyword{misc}
