% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uplot_dbe_vs_o.R
\name{uplot_dbe_vs_o}
\alias{uplot_dbe_vs_o}
\title{Plot DBE vs Oxygen Atoms (cf. Herzsprung et al. 2014) with Option for Interactive Plot}
\usage{
uplot_dbe_vs_o(
  df,
  z_var = "norm_int",
  palname = "redblue",
  col_bar = TRUE,
  tf = FALSE,
  logo = TRUE,
  cex.axis = 12,
  cex.lab = 15,
  plotly = FALSE,
  ...
)
}
\arguments{
\item{df}{A data frame containing the data. The columns \verb{16O} (number of oxygen atoms), \code{dbe} (DBE values),
and the column specified in \code{z_var} should be present in the data.}

\item{z_var}{Character. Column name for variable used for color-coding. Content of column should be numeric.}

\item{palname}{Color palette name for f_colorz() (viridis, magma, plasma, etc.).}

\item{col_bar}{Logical. If \code{TRUE}, adds a color legend (default is \code{TRUE}).}

\item{tf}{Logical. If \code{TRUE}, applies a transformation to the color scale (default is \code{FALSE}).}

\item{logo}{Logical. If TRUE, adds a UME caption.}

\item{cex.axis}{Numeric. Size of axis text (default is \code{1}).}

\item{cex.lab}{Numeric. Size of axis labels (default is \code{1.4}).}

\item{plotly}{Logical. If TRUE, return interactive plotly object.}

\item{...}{
  Arguments passed on to \code{\link[=f_colorz]{f_colorz}}
  \describe{
    \item{\code{z}}{Numeric vector. Values whose colors should be computed.}
    \item{\code{col_num}}{Integer. Number of colors in the palette (default: \code{100}).}
    \item{\code{verbose}}{logical; if \code{TRUE}, show progress messages.}
  }}
}
\value{
A ggplot object or a plotly object depending on the \code{plotly} argument.
}
\description{
This function generates a scatter plot of Double Bond Equivalent (DBE) versus the number of oxygen atoms (\code{o}).
It allows for optional customization of colors based on a specified variable (\code{z_var}) and offers the
option to convert the plot to an interactive plotly object.
}
