% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate_twoclass}
\alias{simulate_twoclass}
\title{simulate two class data}
\usage{
simulate_twoclass(ntrain, ntest, wide = TRUE)
}
\arguments{
\item{ntrain}{number of training examples.}

\item{ntest}{number of test examples.}

\item{wide}{logical. If TRUE \code{p=500}, else \code{p=100}.}
}
\value{
a list with components "x", "y", "xtest", "ytest", "mutest", and "sigma", where "mutest" is the true test mean, and "ytest <- mutest + rnorm(ntest)*sigma."
}
\description{
simulate two class data
}
\examples{
dat = simulate_twoclass(300,3000)
fit = cv.uniLasso(dat$x, dat$y, family="binomial")
misclass = mean( sign(predict(fit, dat$xtest,s="lambda.min"))== sign(dat$ytest-0.5))
}
