% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coh_immunization.R
\name{get_immunization_dose}
\alias{get_immunization_dose}
\title{Return Column Name Associated to Immunizing Vaccine}
\usage{
get_immunization_dose(
  data_set,
  immunization_date_col,
  vacc_date_col,
  immunization_delay
)
}
\arguments{
\item{data_set}{\code{data.frame} with cohort information.}

\item{vacc_date_col}{Name of the column(s) that contain the vaccine dates.}

\item{immunization_delay}{Characteristic time in days before the patient
is considered immune.}
}
\value{
Name of the column taken as immunizing vaccine for each register.
}
\description{
This function is used in cases where several columns with
vaccine dates are provided by the user. It returns the name of the column
of the vaccine used as immunizing. The parameters are set in agreement with
\code{get_immunization_date}.
}
\keyword{internal}
