% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/session.R
\name{get_profiles_groups_categories_mapping}
\alias{get_profiles_groups_categories_mapping}
\title{Get profile–group–category mappings}
\usage{
get_profiles_groups_categories_mapping()
}
\value{
A data frame with one row per profile–group–category combination,
containing the columns:
\itemize{
\item \code{profileId}
\item \code{categoryId}
\item \code{categoryName}
\item \code{groupId}
\item \code{groupName}
}
Returned invisibly.
}
\description{
Wrapper around \code{get_profiles_groups_categories()} to retrieve
the long-format mapping of profiles to their groups and categories.
}
\details{
Intended for use when you want a relational view of profile metadata
rather than the one-row-per-profile structure returned by \code{get_profiles()}.
}
\examples{
\dontrun{
# Fetch profile–group–category mappings for the current tenant
mappings <- get_profiles_groups_categories_mapping()
head(mappings)
}
}
