% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation.R
\name{leave_one_sector_out}
\alias{leave_one_sector_out}
\title{Leave-One-Sector-Out Cross-Validation}
\usage{
leave_one_sector_out(panel_data, verbose = TRUE)
}
\arguments{
\item{panel_data}{Data frame in panel format.}

\item{verbose}{Logical. Print progress. Default TRUE.}
}
\value{
A data frame with RMSE and MAE for each held-out sector.
}
\description{
Performs LOSO CV, leaving out each sector in turn as the test set.
}
\examples{
\donttest{
if (requireNamespace("plm", quietly = TRUE)) {
  set.seed(123)
  panel <- data.frame(
    year = rep(2000:2019, 5),
    sector = rep(LETTERS[1:5], each = 20),
    log_direct = rnorm(100, 5, 0.5),
    log_production = rnorm(100, 5, 0.5)
  )
  panel$log_production <- panel$log_direct * 0.95 + rnorm(100, 0, 0.1)

  loso_results <- leave_one_sector_out(panel)
  print(loso_results)
}
}

}
