% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/divergence_field.R
\name{divergence_field}
\alias{divergence_field}
\title{Numerical divergence of a vector field}
\usage{
divergence_field(field, x0, h = NULL, plot = FALSE)
}
\arguments{
\item{field}{Function of the form \code{field(x)} returning a numeric vector
of the same length as \code{x}.}

\item{x0}{Numeric vector giving the evaluation point.}

\item{h}{Step size for finite differences. Can be:
\itemize{
\item \code{NULL}: an automatic step is selected as
\code{1e-4 * (1 + abs(x0))};
\item A numeric scalar: same step for all components;
\item A numeric vector of the same length as \code{x0}.
}}

\item{plot}{Logical; if \code{TRUE} and the dimension is 2 or 3,
a basic visualization is drawn with \pkg{plotly}.}
}
\value{
A numeric scalar: the divergence evaluated at \code{x0}.
}
\description{
Computes the divergence of a vector field at a given point using
central finite differences. The vector field \code{field} must take a
numeric vector \code{x} and return a numeric vector of the same length.
}
\details{
Optionally, if the dimension is 2 or 3 and \code{plot = TRUE},
a simple visualization is produced using \pkg{plotly}.
}
\examples{
field <- function(x) c(x[1] + x[2], x[2] - x[1])
divergence_field(field, c(0.5, -0.2))

}
