% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gradient_scalar.R
\name{gradient_scalar}
\alias{gradient_scalar}
\title{Gradient of a scalar field in R^n}
\usage{
gradient_scalar(f, x0, h = NULL, plot = FALSE)
}
\arguments{
\item{f}{Function of a numeric vector \code{f(x)} returning a numeric scalar.}

\item{x0}{Numeric vector giving the evaluation point.}

\item{h}{Numeric step size for finite differences. Can be:
\itemize{
\item \code{NULL} (default): a step is chosen as \code{1e-4 * (1 + abs(x0))} for each component;
\item A scalar, used for all components;
\item A numeric vector of the same length as \code{x0}.
}}

\item{plot}{Logical; if \code{TRUE} and \code{length(x0)} is 2 or 3,
draws the gradient vector with \pkg{plotly}.}
}
\value{
A numeric vector of the same length as \code{x0} with the
components of the gradient.
}
\description{
Computes a numerical approximation of the gradient of a scalar function
at a given point using central finite differences. The function \code{f}
is assumed to take a numeric vector as input and return a scalar.
}
\details{
Optionally, if the input point has length 2 or 3 and \code{plot = TRUE},
a simple visualization of the gradient vector is produced using
\pkg{plotly}.
}
\examples{
f <- function(v) exp(-(v[1]^2 + v[2]^2)) + 0.3 * sin(2 * v[1] * v[2])
gradient_scalar(f, c(0.6, -0.4))

}
