% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partial_derivative_surface.R
\name{partial_derivatives_surface}
\alias{partial_derivatives_surface}
\title{Partial derivatives of z = f(x, y) at a point with 3D visualization}
\usage{
partial_derivatives_surface(
  f,
  x0,
  y0,
  h = NULL,
  xlim = NULL,
  ylim = NULL,
  nx = 60L,
  ny = 60L,
  plot = TRUE,
  scene = list(aspectmode = "data", xaxis = list(title = "x"), yaxis = list(title = "y"),
    zaxis = list(title = "z")),
  bg = list(paper = "white", plot = "white")
)
}
\arguments{
\item{f}{Function \code{function(x, y)} returning a numeric scalar \code{f(x, y)}.}

\item{x0, y0}{Numeric scalars; coordinates of the point where the partial
derivatives are evaluated.}

\item{h}{Numeric step for the central finite differences. If \code{NULL},
a default value is chosen as \code{1e-4 * (1 + max(abs(x0), abs(y0)))}.}

\item{xlim}{Numeric length-2 vector \code{c(x_min, x_max)}. Range for the
\eqn{x}-axis used to draw the surface. If \code{NULL}, a symmetric window
around \code{x0} is used.}

\item{ylim}{Numeric length-2 vector \code{c(y_min, y_max)}. Range for the
\eqn{y}-axis used to draw the surface. If \code{NULL}, a symmetric window
around \code{y0} is used.}

\item{nx, ny}{Integer grid sizes (number of points) along \code{x} and \code{y}
for the surface plot. Recommended values are at least 20.}

\item{plot}{Logical; if \code{TRUE}, builds and returns a \pkg{plotly}
surface plot. If \code{FALSE}, only the numeric derivatives are returned.}

\item{scene}{List with \pkg{plotly} 3D scene options (axis titles, aspect
mode, and so on) passed to \code{plotly::layout()}.}

\item{bg}{List with background colors for \pkg{plotly}, with components
\code{paper} and \code{plot}.}
}
\value{
A list with components:
\itemize{
\item \code{fx}: numeric scalar, approximation of \eqn{f_x(x_0, y_0)}.
\item \code{fy}: numeric scalar, approximation of \eqn{f_y(x_0, y_0)}.
\item \code{f0}: numeric scalar, \eqn{f(x_0, y_0)}.
\item \code{fig}: a \pkg{plotly} object if \code{plot = TRUE} and
\pkg{plotly} is available; otherwise \code{NULL}.
}
}
\description{
Numerically approximates the partial derivatives
\eqn{f_x(x_0, y_0)} and \eqn{f_y(x_0, y_0)} of a scalar field
\eqn{z = f(x, y)} at a given point \eqn{(x_0, y_0)} using central
finite differences.
}
\details{
Optionally, it builds a 3D \pkg{plotly} surface for \eqn{z = f(x, y)}
on a rectangular window around \eqn{(x_0, y_0)} and overlays:
\itemize{
\item the intersection curve of the surface with the plane \eqn{y = y_0}
and its tangent line given by \eqn{f_x(x_0, y_0)};
\item the intersection curve with the plane \eqn{x = x_0} and its
tangent line given by \eqn{f_y(x_0, y_0)};
\item the base point \eqn{(x_0, y_0, f(x_0, y_0))}.
}
}
\examples{
\dontshow{if (interactive()) \{}
f <- function(x, y) x^2 + 3 * x * y - y^2
res <- partial_derivatives_surface(
  f,
  x0 = 1, y0 = -1,
  xlim = c(-1, 3),
  ylim = c(-3, 1),
  nx = 60, ny = 60
)
res$fx
res$fy
\dontshow{\}}

}
