% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ef_china.R
\name{ef_china_det}
\alias{ef_china_det}
\title{Correction of Chinese emission factors by deterioration}
\usage{
ef_china_det(v = "PV", t = "Small", f = "G", standard, yeardet = 2015, p)
}
\arguments{
\item{v}{Character; category vehicle: "PV" for Passenger Vehicles or 'Trucks"}

\item{t}{Character; sub-category of of vehicle: PV Gasoline:  "Mini", "Small","Medium",
"Large", "Taxi", "Motorcycles", "Moped", PV Diesel: "Mediumbus", "Largebus",
 "3-Wheel". Trucks: "Mini", "Light" , "Medium", "Heavy"}

\item{f}{Character;fuel: "G", "D", "CNG", "ALL"}

\item{standard}{Character vector; "PRE", "I", "II", "III", "IV", "V".}

\item{yeardet}{Integer; any of 2014, 2015, 2016, 2017, 2018}

\item{p}{Character; pollutant: "CO", "NOx","HC", "PM", "Evaporative_driving"
or "Evaporative_parking"}
}
\value{
long data.frame
}
\description{
Correction of Chinese emission
}
\examples{
{
ef_china_det(standard = "I", p = "CO")
ef_china_det(standard = c("I", "III"),
             p = "CO",
             f = "D")
}
}
\seealso{
Other China: 
\code{\link{ef_china}()},
\code{\link{ef_china_h}()},
\code{\link{ef_china_hu}()},
\code{\link{ef_china_long}()},
\code{\link{ef_china_s}()},
\code{\link{ef_china_speed}()},
\code{\link{ef_china_te}()},
\code{\link{ef_china_th}()},
\code{\link{emis_china}()},
\code{\link{emis_long}()}
}
\concept{China}
