% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trellis_vismi_overimp.R
\name{trellis_vismi_overimp}
\alias{trellis_vismi_overimp}
\title{Trelliscope Visualisation of Overimputation Diagnostics}
\usage{
trellis_vismi_overimp(
  obj,
  m = NULL,
  imp_idx = NULL,
  integerAsFactor = FALSE,
  title = "auto",
  subtitle = "auto",
  num_plot = "cv",
  fac_plot = "cv",
  train_color_pal = NULL,
  test_color_pal = NULL,
  stack_y = FALSE,
  diag_color = "white",
  seed = 2025,
  nrow = 2,
  ncol = 4,
  path = NULL,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{obj}{An object of class 'overimp' containing imputed datasets and parameters.}

\item{m}{A single positive integer specifying the number of imputed datasets to plot. It should be smaller than the total number of imputed datasets in the object. Default is NULL (
plot all).}

\item{imp_idx}{A vector of integers specifying the indices of imputed datasets to plot. Default is NULL (plot all).}

\item{integerAsFactor}{A logical indicating whether integer variables should be treated as factors. Default is FALSE (treated as numeric).}

\item{title}{A string specifying the title of the plot. Default is "auto" (automatic title). If NULL, no title is shown.}

\item{subtitle}{A string specifying the subtitle of the plot. Default is "auto" (automatic subtitle). If NULL, no subtitle is shown.}

\item{num_plot}{A character string specifying the type of plot for numeric variables. Options are "cv" (cross-validation), "ridge", or "density". Default is "cv".}

\item{fac_plot}{A character string specifying the type of plot for categorical variables. Options are "cv" (cross-validation), "bar", or "dodge". Default is "cv".}

\item{train_color_pal}{A vector of colors for the training data. If NULL, default colors will be used.}

\item{test_color_pal}{A vector of colors for the test data. If NULL, default colors will be used.}

\item{stack_y}{A logical indicating whether to stack y-values in the plots. Default is FALSE.}

\item{diag_color}{A color specification for the diagonal line in the plots. Default is NULL.}

\item{seed}{An integer seed for reproducibility. Default is 2025.}

\item{nrow}{Number of rows in the Trelliscope display. Default is 2.}

\item{ncol}{Number of columns in the Trelliscope display. Default is 4.}

\item{path}{Optional path to save the Trelliscope display. If NULL, the display will not be saved to disk.}

\item{verbose}{A logical value indicating whether to print extra information. Default is FALSE.}

\item{...}{Additional arguments to customize the plots, such as point_size, xlim, ylim.}
}
\value{
A Trelliscope display object visualising overimputation diagnostics for all variables.
}
\description{
Generates a Trelliscope display for overimputation diagnostics across all variables.
}
\examples{
obj <- overimp(data = nhanes3, m = 3, p = 0.2, test_ratio = 0, method = "mixgb")
trellis_vismi_overimp(obj = obj, stack_y = TRUE)
}
