% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catalog2pdf.R
\name{catalog2pdf}
\alias{catalog2pdf}
\title{Combine \code{\link{catalog}} images into pdfs}
\usage{
catalog2pdf(
  keep.img = TRUE,
  overwrite = FALSE,
  parallel = 1,
  path = NULL,
  pb = TRUE,
  by.img.suffix = FALSE,
  ...
)
}
\arguments{
\item{keep.img}{Logical argument. Indicates whether jpeg files should be kept (default) or remove.}

\item{overwrite}{Logical argument. If \code{TRUE} all jpeg pdf will be produced again
when code is rerun. If \code{FALSE} only the ones missing will be produced. Default is \code{FALSE}.}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing).}

\item{path}{Character string containing the directory path where the catalog image files are located.
If \code{NULL} (default) then the current working directory is used.}

\item{pb}{Logical argument to control progress bar. Default is \code{TRUE}.}

\item{by.img.suffix}{Logical. If \code{TRUE} catalogs with the same image suffix will be
put together in a single pdf (so one pdf per image suffix in the catalog
images). Default is \code{FALSE} (i.e. no suffix).}

\item{...}{Additional arguments to be passed to the internal pdf creating function \code{\link[grDevices]{pdf}} for customizing output.}
}
\value{
Image files in pdf format with spectrogram catalogs in the working directory.
}
\description{
\code{catalog2pdf} combines \code{\link{catalog}} jpeg images into pdfs
}
\details{
The function combines catalog images in .jpeg format from the \code{\link{catalog}} function into pdfs. Images must be saved in .jpeg format. Note that using lower resolution and smaller dimension (width and height) when creating catalogs will substantially decrease the size of pdf files (which could be pretty big).
}
\examples{
\dontrun{
# save sound file examples
data(list = c("Phae.long1", "Phae.long2"))
writeWave(Phae.long1, file.path(tempdir(), "Phae.long1.wav"))
writeWave(Phae.long2, file.path(tempdir(), "Phae.long2.wav"))

catalog(X = lbh_selec_table, nrow = 2, ncol = 4)

# now create single pdf removing jpeg
catalog2pdf(keep.img = FALSE, path = tempdir())

# check this floder
tempdir()
}
}
\references{
Araya-Salas, M., & Smith-Vidaurre, G. (2017). warbleR: An R package to streamline analysis of animal acoustic signals. Methods in Ecology and Evolution, 8(2), 184-191.
}
\seealso{
\code{\link{full_spectrogram2pdf}}, \code{\link{catalog}}
}
\author{
Marcelo Araya-Salas (\email{marcelo.araya@ucr.ac.cr})
}
