% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdr.R
\name{gg_hdrboxplot}
\alias{gg_hdrboxplot}
\title{HDR plot}
\usage{
gg_hdrboxplot(
  data,
  var1,
  var2 = NULL,
  prob = c(0.5, 0.99),
  color = "#0072b2",
  show_points = FALSE,
  show_anomalies = TRUE,
  alpha = NULL,
  jitter = TRUE,
  ngrid = 501,
  ...
)
}
\arguments{
\item{data}{A data frame or matrix containing the data.}

\item{var1}{The name of the first variable to plot (a bare expression).}

\item{var2}{Optionally, the name of the second variable to plot (a bare expression).}

\item{prob}{A numeric vector specifying the coverage probabilities for the HDRs.}

\item{color}{The base color to use for the mode. Colors for the HDRs are generated
by whitening this color.}

\item{show_points}{A logical argument indicating if a regular HDR plot is required
(\code{FALSE}), or whether to show the individual observations in the same colors (\code{TRUE}).}

\item{show_anomalies}{A logical argument indicating if the surprisal anomalies should be shown (in black).
These are points with leave-one-out surprisal probability values less than 0.005 (using a GPD approximation),
and which lie outside the 99\% HDR region.}

\item{alpha}{Transparency of points. Ignored if \code{show_points} is \code{FALSE}.
Defaults to min(1, 500/n), where n is the number of observations plotted.}

\item{jitter}{A logical value indicating if the points should be vertically jittered
for the 1d box plots to reduce overplotting.}

\item{ngrid}{Number of grid points to use for the density function.}

\item{...}{Other arguments passed to \code{\link{dist_kde}}.}
}
\value{
A ggplot object showing an HDR plot or scatterplot of the data.
}
\description{
Produces a 1d or 2d box plot of HDR regions. The darker regions
contain observations with higher probability, while the lighter regions contain
points with lower probability. Observations outside the largest HDR are shown
as individual points. Anomalies with leave-one-out surprisal probabilities
less than 0.005 are optionally shown in black.
}
\details{
The original HDR boxplot proposed by Hyndman (1996), can be produced
with \code{show_anomalies = FALSE}, \code{jitter = FALSE}, \code{alpha = 1}, and all other
arguments set to their defaults.
}
\examples{
df <- data.frame(x = c(rnorm(1000), rnorm(1000, 5, 1), 10))
gg_hdrboxplot(df, x, show_anomalies = TRUE)
cricket_batting |>
  filter(Innings > 20) |>
  gg_hdrboxplot(Average)
oldfaithful |>
  gg_hdrboxplot(duration, waiting, show_points = TRUE)

}
\references{
Hyndman, R J (1996) Computing and Graphing Highest Density Regions,
\emph{The American Statistician}, \strong{50}(2), 120–126. \url{https://robjhyndman.com/publications/hdr/}

Rob J Hyndman (2026) "That's weird: Anomaly detection using R", Section 5.7,
\url{https://OTexts.com/weird/}.
}
\seealso{
\code{\link{surprisals}}, \code{\link{hdr_table}}
}
\author{
Rob J Hyndman
}
