% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataMerge.R
\name{meld}
\alias{meld}
\title{Merge two or more data frames magically according to their candidate key}
\usage{
meld(
  ...,
  by = NULL,
  all = TRUE,
  no.dups = FALSE,
  csv = FALSE,
  rdata = FALSE,
  spss = FALSE
)
}
\arguments{
\item{...}{Clean data frames to be merged.}

\item{by}{A vector of strings specifying the column names to be used as merge keys. If NULL,
the function automatically determines common keys from the provided data frames.}

\item{all}{Logical; if TRUE, performs an OUTER JOIN. If FALSE, performs an INNER JOIN.}

\item{no.dups}{Logical; if TRUE, duplicates are removed post-merge.}

\item{csv}{Logical; if TRUE, the merged data frame is exported as a CSV file.}

\item{rdata}{Logical; if TRUE, the merged data frame is saved as an Rda file.}

\item{spss}{Logical; if TRUE, the merged data frame is exported as an SPSS file.}
}
\value{
A merged data frame based on the specified or common candidate keys.
}
\description{
This function simplifies the process of merging multiple cleaned data frames by automatically determining
common merge keys or utilizing user-specified keys. Supports both inner and outer join methods,
and offers options for exporting the merged data.
}
\examples{
\dontrun{
# Create sample dataframes for demonstration
df1 <- data.frame(
  src_subject_id = c("S001", "S002", "S003"),
  visit = c(1, 2, 1),
  measure1 = c(10, 15, 12),
  stringsAsFactors = FALSE
)

df2 <- data.frame(
  src_subject_id = c("S001", "S002", "S004"),
  visit = c(1, 2, 2),
  measure2 = c(85, 92, 78),
  stringsAsFactors = FALSE
)

# Perform an OUTER JOIN using default keys:
merged1 <- meld(df1, df2, all = TRUE)

# Perform an INNER JOIN using specified keys:
merged2 <- meld(df1, df2, by = "src_subject_id", all = FALSE)
}
}
\author{
Joshua Kenney \href{mailto:joshua.kenney@yale.edu}{joshua.kenney@yale.edu}
}
