% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_ghcn_stations.R
\name{import_ghcn_countries}
\alias{import_ghcn_countries}
\title{Import FIPS country codes and State/Province/Territory codes used by the
Global Historical Climatology Network}
\usage{
import_ghcn_countries(
  table = c("countries", "states"),
  database = c("hourly", "daily", "monthly")
)
}
\arguments{
\item{table}{One of \code{"countries"} or \code{"states"}.}

\item{database}{One of \code{"hourly"}, \code{"daily"} or \code{"monthly"}, which defines
which of the NOAA databases to import the FIPS codes from. There is little
difference between the data in the different sources, but this option may
be useful if one of the services is not accessible.}
}
\value{
a \link[tibble:tibble-package]{tibble}
}
\description{
This function returns a two-column dataframe either of "Federal Information
Processing Standards" (FIPS) codes and the countries to which they are
associated, or state codes and their associated states. These may be a useful
reference when examining GHCN site metadata.
}
\seealso{
Other GHCN functions: 
\code{\link{import_ghcn_daily}()},
\code{\link{import_ghcn_hourly}()},
\code{\link{import_ghcn_inventory}()},
\code{\link{import_ghcn_monthly_temp}()},
\code{\link{import_ghcn_stations}()}
}
\author{
Jack Davison
}
\concept{GHCN functions}
