% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list.R
\name{describe_table}
\alias{describe_table}
\title{Describe a table}
\usage{
describe_table(wrds, library, table, n = 20, max_cols = 25)
}
\arguments{
\item{wrds}{A \code{DBIConnection} object returned by \code{\link[=wrds_connect]{wrds_connect()}}.}

\item{library}{Character. The name of the library (schema).}

\item{table}{Character. The name of the table.}

\item{n}{Integer. Number of sample rows to fetch for value preview.
Default is 20.}

\item{max_cols}{Integer. Maximum number of columns to display. Default is 25.}
}
\value{
Invisibly returns a list with components:
\describe{
\item{columns}{A data frame with \code{column_name} and \code{data_type}}
\item{nrow}{Row count}
\item{sample}{A data frame with sample rows (if \code{n > 0})}
}
}
\description{
Displays a glimpse-like summary of a WRDS table showing column names
and types, similar to \code{\link[dplyr:glimpse]{dplyr::glimpse()}}.
}
\examples{
\dontrun{
wrds <- wrds_connect()
describe_table(wrds, "comp", "funda")
wrds_disconnect(wrds)
}
}
