% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_multiple_response_table.R
\name{apply_NA_rules}
\alias{apply_NA_rules}
\title{Apply NA handling rules to multiple-response data}
\usage{
apply_NA_rules(
  x,
  use_NA,
  mcols,
  cols = NULL,
  exclude_codes = NULL,
  exclude_label = NULL,
  call = caller_env()
)
}
\arguments{
\item{x}{A \code{data.frame} containing multiple-response data.}

\item{use_NA}{Logical; if \code{TRUE}, adds an indicator column for fully missing
responses. If \code{FALSE}, removes rows with only missing responses.}

\item{mcols}{Character string specifying the common prefix for the
multiple-response columns.}

\item{cols}{Character vector of additional column names to check for
non-missing values when filtering. Defaults to \code{NULL}.}

\item{exclude_codes}{Vector of values representing "seen but answered"
responses. If provided, an indicator column is created to capture this
state and corresponding response values are converted to \code{NA}.}

\item{exclude_label}{Character string naming the "seen but answered"
indicator column. If \code{NULL}, it is constructed automatically by
concatenating \code{exclude_codes} values with underscores.}

\item{call}{Environment used for error reporting, typically from
\code{\link[rlang:stack]{rlang::caller_env()}}.}
}
\value{
A modified \code{data.frame} that:
\itemize{
\item Includes an additional \code{"<mcols>_<exclude_label>"} column
if \code{exclude_codes} values are specified.
\item Includes an additional \code{"<mcols>_NA"} column if \code{use_NA = TRUE}.
\item Is filtered to exclude rows containing only \code{NA} values in relevant
columns if \code{use_NA = FALSE}.
}

The returned object preserves the same class as \code{x}.
}
\description{
This internal helper function applies NA-handling rules to a multiple-response
dataset. It modifies the input \code{data.frame} by adding indicator columns or by
filtering rows based on missingness. Specifically, it can:
}
\details{
\itemize{
\item Add a \emph{"seen but answered"} indicator column, if values representing this
state are supplied via \code{exclude_codes}.
\item Add an \emph{NA indicator column} (named \code{"<mcols>_NA"}) when \code{use_NA = TRUE},
marking rows where all multiple-response columns are \code{NA}.
\item When \code{use_NA = FALSE}, remove rows that contain only \code{NA} values across
the relevant columns.
}

This function is intended for internal use and not exported.
}
\keyword{internal}
