







//! # fn main() -> Result<(), Box<dyn std::error::Error>> {



//! #[derive(serde::Serialize, serde::Deserialize, Debug)]
//! #[serde(transparent)]

//!     #[serde(with = "either::serde_untagged")]








//! assert_eq!(serde_json::to_string(&data)?, r#"["Hello"]"#);



//!     r#"{"a": 0, "b": 14}"#


//! # Ok(())
//! # }


use serde::{Deserialize, Deserializer, Serialize, Serializer};

#[derive(serde::Serialize, serde::Deserialize)]
#[serde(untagged)]
enum Either<L, R> {
    Left(L),
    Right(R),
}

pub fn serialize<L, R, S>(this: &super::Either<L, R>, serializer: S) -> Result<S::Ok, S::Error>
where
    S: Serializer,
    L: Serialize,
    R: Serialize,
{
    let untagged = match this {
        super::Either::Left(left) => Either::Left(left),
        super::Either::Right(right) => Either::Right(right),
    };
    untagged.serialize(serializer)
}

pub fn deserialize<'de, L, R, D>(deserializer: D) -> Result<super::Either<L, R>, D::Error>
where
    D: Deserializer<'de>,
    L: Deserialize<'de>,
    R: Deserialize<'de>,
{
    match Either::deserialize(deserializer) {
        Ok(Either::Left(left)) => Ok(super::Either::Left(left)),
        Ok(Either::Right(right)) => Ok(super::Either::Right(right)),
        Err(error) => Err(error),
    }
}
