






//! # Contents

//! * [Similarities](#similarities)
//! * [Some key differences](#some-key-differences)
//! * [The ndarray ecosystem](#the-ndarray-ecosystem)
//! * [Other Rust array/matrix crates](#other-rust-arraymatrix-crates)
//! * [Rough `ndarray`–NumPy equivalents](#rough-ndarraynumpy-equivalents)

//!   * [Array creation](#array-creation)
//!   * [Indexing and slicing](#indexing-and-slicing)
//!   * [Shape and strides](#shape-and-strides)
//!   * [Mathematics](#mathematics)
//!   * [Array manipulation](#array-manipulation)
//!   * [Iteration](#iteration)
//!   * [Type conversions](#type-conversions)
//!   * [Convenience methods for 2-D arrays](#convenience-methods-for-2-d-arrays)

//! # Similarities


















//! * [index arrays](https://docs.scipy.org/doc/numpy/user/basics.indexing.html#index-arrays)
//! * [mask index arrays](https://docs.scipy.org/doc/numpy/user/basics.indexing.html#boolean-or-mask-index-arrays)


//! # Some key differences








































































//! # The ndarray ecosystem













//! # Other Rust array/matrix crates






























//! # Rough `ndarray`–NumPy equivalents















//! #
//! # fn main() { let _ = arr0(1); }


//! ## Array creation
































//! # use ndarray::prelude::*;
//! #
















//! ## Indexing and slicing

























//! ## Shape and strides


















//! ## Mathematics


































































































//! [`a * b`, `a + b`, etc.](ArrayBase#arithmetic-operations)



















































































































































//! ## Array manipulation














//! ## Iteration












//! Iterators*](ArrayBase#loops-producers-and-iterators).









//! ## Type conversions




























































































//! [sat_conv]: https://blog.rust-lang.org/2020/07/16/Rust-1.45.0.html#fixing-unsoundness-in-casts
//! [as_typecast]: https://doc.rust-lang.org/reference/expressions/operator-expr.html#type-cast-expressions

//! ## Convenience methods for 2-D arrays









//! [.abs_diff_eq()]: ArrayBase#impl-AbsDiffEq<ArrayBase<S2%2C%20D>>






















//! [.index()]: ArrayBase#impl-Index<I>













































pub mod coord_transform;
pub mod rk_step;
pub mod simple_math;


#[allow(unused_imports)]
use crate::imp_prelude::*;
