





























#[derive(Copy, Clone, Debug, PartialEq, Eq)]
#[non_exhaustive]
pub enum Order
{
    
    RowMajor,
    
    ColumnMajor,
}

impl Order
{
    
    pub const C: Order = Order::RowMajor;

    
    pub const F: Order = Order::ColumnMajor;

    
    #[inline]
    pub fn is_row_major(self) -> bool
    {
        match self {
            Order::RowMajor => true,
            Order::ColumnMajor => false,
        }
    }

    
    #[inline]
    pub fn is_column_major(self) -> bool
    {
        !self.is_row_major()
    }

    
    #[inline]
    pub fn row_major(row_major: bool) -> Order
    {
        if row_major {
            Order::RowMajor
        } else {
            Order::ColumnMajor
        }
    }

    
    #[inline]
    pub fn column_major(column_major: bool) -> Order
    {
        Self::row_major(!column_major)
    }

    
    #[inline]
    pub fn transpose(self) -> Order
    {
        match self {
            Order::RowMajor => Order::ColumnMajor,
            Order::ColumnMajor => Order::RowMajor,
        }
    }
}
