

/*
Run-time CPU feature detection on AArch64 Windows by using IsProcessorFeaturePresent.

Run-time detection of FEAT_LSE on Windows by is_aarch64_feature_detected is supported on Rust 1.70+.
https:

Refs: https:
*/

include!("common.rs");


#[allow(clippy::upper_case_acronyms)]
mod ffi {
    pub(crate) type DWORD = u32;
    pub(crate) type BOOL = i32;

    pub(crate) const FALSE: BOOL = 0;

    
    pub(crate) const PF_ARM_V81_ATOMIC_INSTRUCTIONS_AVAILABLE: DWORD = 34;

    extern "system" {
        
        pub(crate) fn IsProcessorFeaturePresent(ProcessorFeature: DWORD) -> BOOL;
    }
}

#[cold]
fn _detect(info: &mut CpuInfo) {
    
    
    if unsafe {
        ffi::IsProcessorFeaturePresent(ffi::PF_ARM_V81_ATOMIC_INSTRUCTIONS_AVAILABLE) != ffi::FALSE
    } {
        info.set(CpuInfo::HAS_LSE);
    }
}

#[allow(
    clippy::alloc_instead_of_core,
    clippy::std_instead_of_alloc,
    clippy::std_instead_of_core,
    clippy::undocumented_unsafe_blocks,
    clippy::wildcard_imports
)]
#[cfg(test)]
mod tests {
    use super::*;

    
    
    
    
    
    
    
    
    
    
    
    #[allow(clippy::cast_possible_wrap, clippy::cast_sign_loss, clippy::cast_possible_truncation)]
    const _: fn() = || {
        let _: ffi::DWORD = 0 as windows_sys::Win32::System::Threading::PROCESSOR_FEATURE_ID;
        let _: ffi::BOOL = 0 as windows_sys::Win32::Foundation::BOOL;
        let mut _is_processor_feature_present: unsafe extern "system" fn(ffi::DWORD) -> ffi::BOOL =
            ffi::IsProcessorFeaturePresent;
        _is_processor_feature_present =
            windows_sys::Win32::System::Threading::IsProcessorFeaturePresent;
        static_assert!(ffi::FALSE == windows_sys::Win32::Foundation::FALSE);
        static_assert!(
            ffi::PF_ARM_V81_ATOMIC_INSTRUCTIONS_AVAILABLE
                == windows_sys::Win32::System::Threading::PF_ARM_V81_ATOMIC_INSTRUCTIONS_AVAILABLE
        );
    };
}
