% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_su.R
\docType{data}
\name{vars_su_y_alcprob}
\alias{vars_su_y_alcprob}
\alias{compute_su_y_alcprob_prsum}
\title{Compute "Alcohol Problem Index (RAPI) [Youth]: Prorated sum"}
\format{
vars_su_y_alcprob is a table with pairs of baseline and longitudinal
redcap fields used to compute summary score of \code{su_y_alcprob_prsum} and
\code{su_y_alcprob_nm}.
}
\usage{
vars_su_y_alcprob

compute_su_y_alcprob_prsum(
  data,
  name = "su_y_alcprob_prsum",
  combine = TRUE,
  max_na = 2
)
}
\arguments{
\item{data}{tbl. Data frame containing the columns to be summarized.}

\item{name}{character, Name of the new column to be created. Default is
the name in description, but users can change it.}

\item{combine}{logical, If \code{TRUE} (default), the summary score will be appended to
the input data frame. If \code{FALSE}, the summary score for each participant
will be returned as a separate data frame. (Default: TRUE)}

\item{max_na}{numeric, positive whole number. Number of missing items
allowed (Default: 1).}
}
\value{
tbl. The input data frame with the summary score appended as
a new column.
}
\description{
Computes the summary score \code{su_y_alcprob_prsum}
Alcohol Problem Index (RAPI) [Youth]: Prorated sum [Validation: No more
than 2 missing or declined]
\itemize{
\item \emph{Summarized variables:}
\itemize{
\item \code{su_y_alcprob_001}
\item \code{su_y_alcprob_002}
\item \code{su_y_alcprob_003}
\item \code{su_y_alcprob_004}
\item \code{su_y_alcprob_005}
\item \code{su_y_alcprob_006}
\item \code{su_y_alcprob_007}
\item \code{su_y_alcprob_008}
\item \code{su_y_alcprob_009}
\item \code{su_y_alcprob_010}
\item \code{su_y_alcprob_012}
\item \code{su_y_alcprob_016}
\item \code{su_y_alcprob_017}
\item \code{su_y_alcprob_018}
\item \code{su_y_alcprob_001__l}
\item \code{su_y_alcprob_002__l}
\item \code{su_y_alcprob_003__l}
\item \code{su_y_alcprob_004__l}
\item \code{su_y_alcprob_005__l}
\item \code{su_y_alcprob_006__l}
\item \code{su_y_alcprob_007__l}
\item \code{su_y_alcprob_008__l}
\item \code{su_y_alcprob_009__l}
\item \code{su_y_alcprob_010__l}
\item \code{su_y_alcprob_012__l}
\item \code{su_y_alcprob_016__l}
\item \code{su_y_alcprob_017__l}
\item \code{su_y_alcprob_018__l}
}
\item \emph{Excluded values:} none
\item \emph{Validation criterion:} maximally 2 items missing
}
}
\keyword{datasets}
