% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sr-mem.R
\name{sr.mem}
\alias{sr.mem}
\title{Implementation of SR-MEM: scale-reliant mixed effects models.}
\usage{
sr.mem(logW, formula, data, n.cores, method, mem.args)
}
\arguments{
\item{logW}{a numeric array (N x D X S) where D is the number of taxa,
N is the number of samples, and S is the number of posterior samples}

\item{formula}{an lme4 formula with fixed and random effects for lmer}

\item{data}{A data.frame with the random and fixed effects items in formula}

\item{n.cores}{The number of cores for parallelization. If n.cores=1, no
parallelization is used}

\item{method}{The mem method to use: either nlme or lme4}

\item{mem.args}{Additional arguments including random or correlation}
}
\value{
A list of (P x D x S)-arrays with the fixed effect point estimates,
the standard errors, degrees of freedom and the lower and upper p-values
for each coefficient (P), of each model fit to each taxa (D) and each
posterior sample (S) and a (Pr x D x S)-array with (Pr) random
effects.
}
\description{
Implementation of SR-MEM: scale-reliant mixed effects models.
}
\author{
Kyle McGovern
}
