% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/particle_dist.R
\name{particle_dist}
\alias{particle_dist}
\title{Create a particle distribution}
\usage{
particle_dist(
  AMAD = 5,
  log_norm_sd = 2.5,
  log_norm_min = 5e-04,
  log_norm_max = 100,
  discrete_vals = c(1, 5, 10)
)
}
\arguments{
\item{AMAD}{default is 5 based on ICRP 66}

\item{log_norm_sd}{default is 2.5 based on ICRP 66}

\item{log_norm_min}{default is 0.0005 based on ICRP 66}

\item{log_norm_max}{default is 100 based on ICRP 66}

\item{discrete_vals}{default is c(1, 5, 10)}
}
\value{
a data frame containing a lognormally distributed set of
particles and discrete particle sizes
}
\description{
Needed as a first step in estimating system efficiency.
Make the data frame that will be used to estimate efficiency of
variously sized aerosol particles' transport through the sampling
system. To create your data, save this data to the global
environment as shown in the examples.
}
\details{
All inputs are in micron AMAD, meaning:
     the aerodynamic diameter of a particle is the diameter of a
     standard density (1000 kg/m3) sphere that has the same
     gravitational settling velocity as the particle in question.
}
\examples{
df <- particle_dist() # default
df <- particle_dist(AMAD = 4.4,
                    log_norm_sd = 1.8)
head(df)

}
