% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JarqueBera_GTest.R
\name{JBGTest}
\alias{JBGTest}
\title{Jarque-Bera Test with Glinskiy Corrections}
\usage{
JBGTest(y, mu = NULL, sigma2 = NULL, alpha = 0.05)
}
\arguments{
\item{y}{A numeric vector to test for normality.}

\item{mu}{Optional known mean value. Default is \code{NULL}.}

\item{sigma2}{Optional known variance value. Default is \code{NULL}.}

\item{alpha}{Significance level for the test (default is 0.05).}
}
\value{
An object of class \code{"normalidad"}, containing:
\itemize{
  \item \code{statistic}: Test statistic value.
  \item \code{df}: Degrees of freedom (always 2).
  \item \code{p_value}: P-value of the test.
  \item \code{decision}: Conclusion about normality.
  \item \code{variant}: Type of JB test applied.
  \item \code{method}: "Jarque-Bera (Glinskiy)"
}
}
\description{
Performs the Jarque-Bera test for normality with optional corrections proposed by Glinskiy et al. (2024),
depending on whether the mean, variance, or both are known a priori.
}
\examples{

data(d_e, package = "Analitica")
JBGTest(d_e$Sueldo_actual)
#output different of result
summary(JBGTest(d_e$Sueldo_actual))


}
\references{
Glinskiy, Vladimir & Ismayilova, Yulia & Khrushchev, Sergey & Logachov, Artem & Logachova, Olga & Serga, Lyudmila & Yambartsev, Anatoly & Zaykov, Kirill. (2024). Modifications to the Jarque–Bera Test. Mathematics. 12. 2523. 10.3390/math12162523.
}
