% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-pgs.R
\name{create.pgs.density.plot}
\alias{create.pgs.density.plot}
\title{Plot PGS Density}
\usage{
create.pgs.density.plot(
  pgs.data,
  pgs.columns = NULL,
  phenotype.columns = NULL,
  output.dir = NULL,
  filename.prefix = NULL,
  file.extension = "png",
  tidy.titles = FALSE,
  width = 10,
  height = 10,
  xaxes.cex = 1.5,
  yaxes.cex = 1.5,
  titles.cex = 1.5,
  key.cex = 1,
  border.padding = 1
)
}
\arguments{
\item{pgs.data}{data.frame PGS data as formatted by \code{apply.polygenic.score()}. Required columns are at least one of PGS, PGS.with.replaced.missing, or PGS.with.normalized.missing.
This function is designed to work with the output of \code{apply.polygenic.score()}.}

\item{pgs.columns}{character vector of column names indicating which columns in \code{pgs.data} to plot as PGSs. If \code{NULL}, defaults to recognized PGS columns: PGS, PGS.with.replaced.missing, and PGS.with.normalized.missing.}

\item{phenotype.columns}{character vector of phenotype columns in \code{pgs.data} to plot (optional)}

\item{output.dir}{character directory to save output plots}

\item{filename.prefix}{character prefix for output filenames}

\item{file.extension}{character file extension for output plots}

\item{tidy.titles}{logical whether to reformat PGS plot titles to remove periods}

\item{width}{numeric width of output plot in inches}

\item{height}{numeric height of output plot in inches}

\item{xaxes.cex}{numeric size for all x-axis labels}

\item{yaxes.cex}{numeric size for all y-axis labels}

\item{titles.cex}{numeric size for all plot titles}

\item{key.cex}{numeric size of color key legend}

\item{border.padding}{numeric padding for plot borders}
}
\value{
If no output directory is provided, a multipanel lattice plot object is returned, otherwise a plot is written to the indicated path and \code{NULL} is returned.
}
\description{
Plot density curves of PGS data outputted by \code{apply.polygenic.score}.
If phenotype columns are provided, multiple density curves are plotted for automatically detected categories for each categorical variable.
}
\examples{
set.seed(100);
pgs.data <- data.frame(
    PGS = rnorm(100, 0, 1)
    );
 temp.dir <- tempdir();

# Basic Plot
create.pgs.density.plot(
    pgs.data,
    output.dir = temp.dir,
    filename.prefix = 'basic-plot',
    width = 6,
    height = 6
    );

# Plot multiple PGS outputs
pgs.data$PGS.with.normalized.missing <- rnorm(100, 1, 1);
\donttest{create.pgs.density.plot(pgs.data, output.dir = temp.dir);}

# Plot non-default PGS columns
pgs.data$PGS.custom <- rnorm(100, 2, 1);
\donttest{create.pgs.density.plot(pgs.data, pgs.columns = 'PGS.custom', output.dir = temp.dir);}

# Plot phenotype categories
pgs.data$sex <- sample(c('male', 'female'), size = 100, replace = TRUE);
\donttest{
create.pgs.density.plot(
    pgs.data,
    output.dir = temp.dir,
    filename.prefix = 'multiple-pgs',
    phenotype.columns = 'sex'
    );
}

# Plot multiple phenotypes
pgs.data$letters <- sample(letters[1:5], size = 100, replace = TRUE);
\donttest{
create.pgs.density.plot(
    pgs.data,
    output.dir = temp.dir,
    filename.prefix = 'multiple-phenotypes',
    phenotype.columns = c('sex', 'letters')
    );
}
}
