% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fw_generative_models.R
\name{create_niche_model}
\alias{create_niche_model}
\title{Create a food web based on the niche model}
\usage{
create_niche_model(S, C)
}
\arguments{
\item{S}{integer, number of species.}

\item{C}{numeric, connectance i.e. the number of realized links over the all
possible links.}
}
\value{
A (square) matrix with zeros (no interaction) and ones (species j
  consume species i).
}
\description{
Function to generate a food web based on the niche model
  (Williams and Martinez, 2000) based on the number of species and
  connectance. Corrections from Allesina et al. (2008) are used.
}
\details{
If at least one species has not resource or consumer (i.e. it is an
  isolated species), another food web is generated, until a maximum of 100
  iterations.
}
\examples{
set.seed(123)
web_niche <- create_niche_model(30, .1)
image(t(web_niche))
}
\references{
Williams, R. J., & Martinez, N. D. (2000). Simple rules yield
  complex food webs. Nature, 404(6774), 180-183.

  Allesina, S., Alonso, D., & Pascual, M. (2008). A general model for food
  web structure. science, 320(5876), 658-661.
}
