% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_argentina_hospital_beds.R
\name{get_argentina_hospital_beds}
\alias{get_argentina_hospital_beds}
\title{Get Argentina's Hospital Beds (per 1,000 people) from World Bank}
\source{
World Bank Open Data API: \url{https://data.worldbank.org/indicator/SH.MED.BEDS.ZS}
}
\usage{
get_argentina_hospital_beds()
}
\value{
A tibble with the following columns:
\itemize{
  \item \code{indicator}: Indicator name (e.g., "Hospital beds (per 1,000 people)")
  \item \code{country}: Country name ("Argentina")
  \item \code{year}: Year of the data (integer)
  \item \code{value}: Number of hospital beds per 1,000 people
}
}
\description{
Retrieves Argentina's number of hospital beds per 1,000 people
for the years 2010 to 2022 using the World Bank Open Data API.
The indicator used is \code{SH.MED.BEDS.ZS}.
}
\details{
This function sends a GET request to the World Bank API.
If the API request fails or returns an error status code,
the function returns \code{NULL} with an informative message.
}
\note{
Requires internet connection.
}
\examples{
if (interactive()) {
  get_argentina_hospital_beds()
}

}
\seealso{
\code{\link[httr]{GET}}, \code{\link[jsonlite]{fromJSON}}, \code{\link[dplyr]{as_tibble}}
}
