% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizePedigree.R
\name{prepSummarizePedigrees}
\alias{prepSummarizePedigrees}
\title{Function to prepare the pedigree for summarization
This function prepares the pedigree for summarization by ensuring that the
necessary IDs are present and that the pedigree is built correctly.}
\usage{
prepSummarizePedigrees(
  ped,
  type,
  verbose = FALSE,
  famID,
  personID,
  momID,
  dadID,
  matID,
  patID
)
}
\arguments{
\item{ped}{a pedigree dataset.  Needs ID, momID, and dadID columns}

\item{type}{Character vector. Specifies which summaries to compute.
Options: `"fathers"`, `"mothers"`, `"families"`. Default includes all three.}

\item{verbose}{Logical, if TRUE, print progress messages.}

\item{famID}{character.  Name of the column to be created in ped for the family ID variable}

\item{personID}{character.  Name of the column in ped for the person ID variable}

\item{momID}{character.  Name of the column in ped for the mother ID variable}

\item{dadID}{character.  Name of the column in ped for the father ID variable}

\item{matID}{Character. Maternal line ID variable to be created and added to the pedigree}

\item{patID}{Character.  Paternal line ID variable to be created and added to the pedigree}
}
\description{
Function to prepare the pedigree for summarization
This function prepares the pedigree for summarization by ensuring that the
necessary IDs are present and that the pedigree is built correctly.
}
