% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multMixNRMI.R
\name{summary.multNRMI}
\alias{summary.multNRMI}
\title{S3 method for class 'multNRMI'}
\usage{
\method{summary}{multNRMI}(object, number_of_clusters = FALSE, ...)
}
\arguments{
\item{object}{A fitted object of class NRMI1cens}

\item{number_of_clusters}{Whether to compute the optimal number of clusters, which can be a time-consuming operation (see \code{\link{compute_optimal_clustering}})}

\item{...}{Further arguments to be passed to generic function, ignored at the moment}
}
\value{
Prints out the text for the summary S3 methods
}
\description{
S3 method for class 'multNRMI'
}
\examples{
\donttest{
data(salinity)
out <- multMixNRMI2cens(salinity$left, salinity$right, parallel = TRUE, Nit = 10, ncores = 2)
summary(out)
}
}
