% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxfunc.R
\name{peer.avg}
\alias{peer.avg}
\title{Computing Peer Averages}
\usage{
peer.avg(Glist, V, export.as.list = FALSE)
}
\arguments{
\item{Glist}{An adjacency matrix or a list of sub-adjacency matrices representing the network structure.}

\item{V}{A vector or matrix of observable characteristics.}

\item{export.as.list}{(optional) A boolean indicating whether the output should be a list of matrices (\code{TRUE}) or a single matrix (\code{FALSE}).}
}
\value{
The matrix product \code{diag(Glist[[1]], Glist[[2]], ...) \%*\% V}, where \code{diag()} represents the block diagonal operator.
}
\description{
The \code{peer.avg} function computes peer average values using network data (provided as a list of adjacency matrices) and observable characteristics.
}
\examples{
# Generate a list of adjacency matrices
## Sub-network sizes
N <- c(250, 370, 120)  
## Rate of friendship
p <- c(0.2, 0.15, 0.18)   
## Network data
u <- unlist(lapply(1:3, function(x) rbinom(N[x] * (N[x] - 1), 1, p[x])))
G <- vec.to.mat(u, N, normalise = TRUE)

# Generate a vector y
y <- rnorm(sum(N))

# Compute G \%*\% y
Gy <- peer.avg(Glist = G, V = y)
}
\seealso{
\code{\link{simnetwork}}, \code{\link{vec.to.mat}}
}
