% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_interface_spending.R
\name{spending}
\alias{spending}
\title{Formula Interface for Spending Models}
\usage{
spending(family, data, optimx.args = list(), verbose = TRUE, ...)
}
\arguments{
\item{family}{A spending model (currently only \code{gg}).}

\item{data}{A \code{clv.data} object.}

\item{optimx.args}{Additional arguments to control the optimization which are forwarded to \code{\link[optimx:optimx]{optimx::optimx}}.
If multiple optimization methods are specified, only the result of the last method is further processed.}

\item{verbose}{Show details about the running of the function.}

\item{...}{Forwarded to model specified in \code{family}.}
}
\value{
Returns an object of the respective model which was fit.
}
\description{
Fit models for customer spending (currently only the Gamma-Gamma model).
}
\examples{
\donttest{

data("cdnow")
clv.cdnow <- clvdata(data.transactions = cdnow, date.format="ymd",
                     time.unit = "weeks")

# Fit gg
spending(family=gg, data=clv.cdnow)

# Fit gg with start params
spending(family=gg, data=clv.cdnow,
         start.params.model=c(p=0.5, q=15, gamma=2))

# Fit gg, do not remove first transaction
spending(family=gg, data=clv.cdnow, remove.first.transaction=FALSE)


## No formula may be given to specify covariates because currently
## no spending model uses covariates

}


}
\seealso{
Spending models for \code{family}: \link{gg}.

\link{latentAttrition} to fit latent attrition models with a
formula interface
}
