% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_Omega.R
\name{modify_Omega}
\alias{modify_Omega}
\title{Modify Omega Parameters in PML Models}
\usage{
modify_Omega(
  PMLParametersSets,
  Name,
  InitialOmega,
  State,
  Frozen,
  PMLStructures = NULL
)
}
\arguments{
\item{PMLParametersSets}{A list of PML parameters sets (\code{PMLModels} class
instance).}

\item{Name}{A character string specifying the name of the Omega.}

\item{InitialOmega}{Numeric specifying the initial value of the Omega. Default value is 1.}

\item{State}{Character specifying the presence of the Omega. Possible values are:
\itemize{
\item \code{None} The Omega does not exist in the specified \code{PMLStructures}.
\item \code{Present} The Omega exists in the specified \code{PMLStructures} (the default).
\item \code{Searched} The presence of the Omega is searched.
}}

\item{Frozen}{A logical value indicating whether the Omega is frozen or not.}

\item{PMLStructures}{Character or character vector specifying names of PML
structures in which the Omega will be modified. For the naming convention
of PMLStructures, see Details section of \code{\link[=create_ModelPK]{create_ModelPK()}} for PK models
and \code{\link[=create_ModelPD]{create_ModelPD()}} for PD models.}
}
\value{
An updated list of PML models (\code{PMLModels} class instance) matching
the specified options.
}
\description{
This function allows to modify Omega parameters in a list of PML models
(\code{PMLModels} class instance created by \code{\link[=get_PMLParametersSets]{get_PMLParametersSets()}}).
}
\details{
\itemize{
\item If the specified Omega does not exist in the PML models, a warning
will be issued, and no modifications will be made.
\item The current functionality does not support modifying custom
omegas (ranefs) that are defined within the PML code of custom model spaces.
}
}
\examples{
PMLParametersSets12 <- create_ModelPK(CompartmentsNumber = c(1, 2))
# Modify an Omega parameter named "nV" with new Initial Estimate and
# Frozen flag
PMLParametersSets12Mod1 <-
  modify_Omega(PMLParametersSets12,
               Name = "nV",
               InitialOmega = 0.3,
               State = "Present",
               Frozen = TRUE,
               PMLStructures = "PK1IVC")

print(PMLParametersSets12Mod1)

}
\seealso{
\code{\link[=list_Omegas]{list_Omegas()}}

Functions used for Omega specification: 
\code{\link{Omega}()},
\code{\link{create_ModelPD}()},
\code{\link{create_ModelPK}()}
}
\concept{Omegas}
