% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analytics.R
\docType{data}
\name{analytics}
\alias{analytics}
\title{DIVINE's table on laboratory data}
\format{
A data frame with 5813 rows and 9 columns
\describe{
\item{record_id:}{Identifier of each record. This information does not match the real data.}
\item{covid_wave:}{A factor with levels \verb{Wave 1}, \verb{Wave 2}, \verb{Wave 3}, and \verb{Wave 5}. COVID-19 wave.}
\item{center:}{A factor with levels \verb{Hospital A}, \verb{Hospital B}, \verb{Hospital C}, \verb{Hospital D}, and             \verb{Hospital E}. Center of admission}
\item{analytics_available:}{Is there an analytic available for this patient?}
\item{total_leukocytes:}{Total leukocytes (mil/mm³)}
\item{hemoglobin:}{Hemoglobin (g/dl)}
\item{total_lymphocytes:}{Total lymphocytes (mil/mm³)}
\item{d_dimer:}{D-dimer (µg/L)}
\item{c_reactive_protein:}{C-reactive protein (mg/L)}
}
}
\usage{
data(analytics)
}
\description{
Information on laboratory data of patients included in the DIVINE cohort. Data was collected at hospital admission.
}
\references{
Pallarès, N., Tebé, C., Abelenda-Alonso, G., Rombauts, A., Oriol, I., Simonetti, A. F., Rodríguez-Molinero, A., Izquierdo, E., Díaz-Brito, V., Molist, G., Gómez Melis, G., Carratalà, J., Videla, S., & MetroSud and Divine study groups (2023). Characteristics and Outcomes by Ceiling of Care of Subjects Hospitalized with COVID-19 During Four Waves of the Pandemic in a Metropolitan Area: A Multicenter Cohort Study. Infectious diseases and therapy, 12(1), 273–289. https://doi.org/10.1007/s40121-022-00705-w
}
\keyword{datasets}
