% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prognosis.R
\name{lasso_pro}
\alias{lasso_pro}
\title{Train Lasso Cox Proportional Hazards Model}
\usage{
lasso_pro(X, y_surv, tune = FALSE)
}
\arguments{
\item{X}{A data frame of predictors.}

\item{y_surv}{A \code{Surv} object containing time and status.}

\item{tune}{Logical. If TRUE, performs internal tuning (currently handled by cv.glmnet automatically).}
}
\value{
An object of class \code{survival_glmnet} and \code{pro_model}.
}
\description{
Fits a Cox proportional hazards model regularized by the Lasso (L1) penalty.
Uses cross-validation to select the optimal lambda.
}
\examples{
\donttest{
  library(survival)
  # Create dummy data
  set.seed(123)
  df <- data.frame(time = rexp(50), status = sample(0:1, 50, replace=TRUE),
                   var1 = rnorm(50), var2 = rnorm(50))
  y <- Surv(df$time, df$status)
  x <- df[, c("var1", "var2")]

  model <- lasso_pro(x, y)
  print(class(model))
}
}
