% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_audit_count.R
\name{get_audit_count}
\alias{get_audit_count}
\title{Get audit count}
\usage{
get_audit_count(query, env = "production")
}
\arguments{
\item{query}{(character) Query (see details below)}

\item{env}{(character) Repository environment. Can be: "production",
"staging", or "development".}
}
\value{
(numeric) Returns a count of the number of audit records matching
the query parameters as specified in the request.
}
\description{
Get audit count
}
\details{
Query parameters are specified as key=value pairs, multiple pairs
must be delimited with ampersands (&), and only a single value should be
specified for a particular key. The following query parameter keys are
allowed:

\itemize{
  \item category - Can be: debug, info, error, warn
  \item service - Any of the EDI data repository services
  \item serviceMethod - Any of the EDI data repository service Resource
  class JAX-RS methods
  \item user - Any user
  \item group - Any group
  \item authSystem - A valid auth system identifier
  \item status - A valid HTTP Response Code
  \item resourceId - An EDI data repository resource identifier, e.g.
  https://pasta.lternet.edu/package/eml/knb-lter-and/2719/6, or a substring 
  thereof (see details below)
  \item fromTime - An ISO8601 timestamp
  \item toTime - An ISO8601 timestamp
  \item limit - A positive whole number
}

The query parameters fromTime and optionally toTime should be used to
indicate a time span. When toTime is absent, the count will include of all
matching records up to the current time. Either of these parameters may only
be used once. The query parameter limit sets an upper limit on the number of
audit records returned. For example, "limit=1000". The query parameter
resourceId will match any audit log entry whose resourceId value contains
the specified string value. Thus, a query parameter of
"resourceId=knb-lter-and" will match any audit log entry whose resourceId
value contains the substring "knb-lter-and", while a query parameter of
"resourceId=knb-lter-and/2719/6" will match any audit log entry whose
resourceId value contains the substring "knb-lter-and/2719/6".
}
\note{
User authentication is required (see \code{login()})
}
\examples{
\dontrun{

login()

# Count the number of warnings issued between 2021-12-01 and 2021-12-05
res <- get_audit_count(
  query = "category=warn&fromTime=2021-12-01&toTime=2021-12-05"
)
res
#> [1] 10022

logout()
}

}
\seealso{
Other Audit Manager Services: 
\code{\link{get_audit_record}()},
\code{\link{get_audit_report}()},
\code{\link{get_docid_reads}()},
\code{\link{get_packageid_reads}()},
\code{\link{get_recent_uploads}()}
}
\concept{Audit Manager Services}
