% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.EFAhclust}
\alias{plot.EFAhclust}
\title{Plot Hierarchical Cluster Analysis Dendrogram}
\usage{
\method{plot}{EFAhclust}(x, ...)
}
\arguments{
\item{x}{An object of class \code{EFAhclust}, representing the results to be plotted.}

\item{...}{Additional arguments to be passed to the plotting function.}
}
\value{
None. This function is used for side effects (plotting).
}
\description{
This function generates a dendrogram from hierarchical cluster analysis results. The hierarchical clustering method
merges the two nodes with the smallest dissimilarity at each step, forming a new node until all nodes are combined
into a single hierarchical structure. The resulting dendrogram represents the hierarchical relationships between items,
where items with high correlation are connected by shorter lines, and items with low correlation are connected by longer lines.
The height of the tree nodes indicates the dissimilarity between nodes: a greater height reflects a larger difference.
Researchers can use this representation to determine if two nodes belong to the same cluster, which in exploratory factor analysis,
helps identify whether items belong to the same latent factor.
}
\examples{
library(EFAfactors)
set.seed(123)

## Take the data.bfi dataset as an example.
data(data.bfi)

response <- as.matrix(data.bfi[, 1:25]) ## Load data
response <- na.omit(response) ## Remove samples with NA/missing values

## Transform the scores of reverse-scored items to normal scoring
response[, c(1, 9, 10, 11, 12, 22, 25)] <- 6 - response[, c(1, 9, 10, 11, 12, 22, 25)] + 1

\donttest{
  EFAhclust.obj <- EFAhclust(response)

  ## Plot the hierarchical clustering dendrogram
  plot(EFAhclust.obj)
}


}
\seealso{
\link[EFAfactors]{EFAhclust}
}
