% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_quantile_levels.R
\name{get_quantile_levels.fars}
\alias{get_quantile_levels.fars}
\title{Extract Quantile Levels from a \code{fars} Object}
\usage{
\method{get_quantile_levels}{fars}(x, ...)
}
\arguments{
\item{x}{An object of class \code{fars}, typically the result of a computation such as \code{compute_fars}.}

\item{...}{Additional arguments (ignored).}
}
\value{
A vector of quantile levels stored within the \code{fars} object.
}
\description{
Returns the quantile levels from an object of class \code{fars}.
}
\examples{
fars_result <- compute_fars(dep_variable = rnorm(100), 
                            factors = matrix(rnorm(100 * 3), ncol = 3))
get_quantile_levels(fars_result)  

}
