% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.IssueTB}
\alias{print.IssueTB}
\alias{print.IssuesTB}
\alias{print.summary.IssueTB}
\alias{print.summary.IssuesTB}
\title{Display IssueTB and IssuesTB object}
\usage{
\method{print}{IssueTB}(x, ...)

\method{print}{IssuesTB}(x, ...)

\method{print}{summary.IssueTB}(x, ...)

\method{print}{summary.IssuesTB}(x, ...)
}
\arguments{
\item{x}{a \code{IssueTB} or \code{IssuesTB} object.}

\item{\dots}{Unused argument}
}
\value{
invisibly (with \code{invisible()}) \code{NULL}.
}
\description{
Display IssueTB and IssuesTB with formatted output in the console
}
\details{
This function displays an issue (\code{IssueTB} object) or a list of issues
(\code{IssuesTB} object) with a formatted output.
}
\examples{
all_issues <- get_issues(
    source = "local",
    dataset_dir = system.file("data_issues", package = "IssueTrackeR"),
    dataset_name = "list_issues.yaml"
)

# Display one issue
print(all_issues[1, ])

# Display several issues
print(all_issues[1:10, ])

# Display the summary of one issue
summary(all_issues[2, ])

# Display the summary of
summary(all_issues[1:10, ])
}
