% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_pc.R
\name{data_pc}
\alias{data_pc}
\title{Data Processing for LLIC Analysis}
\usage{
data_pc(data)
}
\arguments{
\item{data}{A data frame containing the raw data generated for the LLIC analysis.}
}
\value{
A data frame with the following columns:
\item{X1}{The filtered values of the original `X1` column, keeping only rows where `X1 <= 2`.}
\item{X2}{The original `X2` column.}
\item{X1_squared}{A new column containing the square of the `X1` values.}
}
\description{
This function processes the data generated for the LLIC analysis, including filtering, mutation, and selection of specific columns.
}
\examples{
set.seed(12)
library(dplyr)
library(VGAM)
raw_data <- data.frame(
  X1 = sample(1:3, 1200, replace = TRUE),
  X2 = sample(1:3, 1200, replace = TRUE),
  X3 = sample(1:3, 1200, replace = TRUE),
  X4 = sample(1:3, 1200, replace = TRUE),
  X5 = sample(1:3, 1200, replace = TRUE),
  Y = rlaplace(1200, 0, 1)
)
processed_data <- data_pc(raw_data)

}
