% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaps.R
\name{has_gaps}
\alias{has_gaps}
\title{Does a dataset have implicit gaps}
\usage{
has_gaps(dataset, Datetime.colname = Datetime, epoch = "dominant.epoch")
}
\arguments{
\item{dataset}{A light logger dataset. Needs to be a dataframe.}

\item{Datetime.colname}{The column that contains the datetime. Needs to be a
\code{POSIXct} and part of the dataset.}

\item{epoch}{The epoch to use for the gapless sequence. Can be either a
\code{lubridate::duration()} or a string. If it is a string, it needs to be
either '"dominant.epoch"' (the default) for a guess based on the data or a
valid \code{lubridate::duration()} string, e.g., \code{"1 day"} or \code{"10 sec"}.}
}
\value{
logical
}
\description{
Returns \code{TRUE} if there are implicit gaps in the dataset and \code{FALSE} if it is
gapless. Gaps can make sense depending on the grouping structure, but the
general sequence of Datetimes within a dataset should always be gapless.
}
\examples{
#The sample dataset does not have gaps
sample.data.environment |> has_gaps()
#removing some of the data creates gaps
sample.data.environment |> dplyr::filter(MEDI <= 50000) |> has_gaps()

#having a grouped dataframe where the groups span multiple unconnected parts 
#is considered a gap, which can be relevant, e.g., when searching for clusters
sample.data.environment |>
  add_photoperiod(c(47.1, 10)) |>
  dplyr::group_by(photoperiod.state) |>
  has_gaps()

 #to avoid this, use `number_states()` for grouping
 sample.data.environment |>
  add_photoperiod(c(48.52, 9.06)) |>
  number_states(photoperiod.state) |>
  dplyr::group_by(photoperiod.state.count, .add = TRUE) |>
  has_gaps()
}
\seealso{
Other regularize: 
\code{\link{dominant_epoch}()},
\code{\link{extract_gaps}()},
\code{\link{gap_finder}()},
\code{\link{gap_handler}()},
\code{\link{gapless_Datetimes}()},
\code{\link{has_irregulars}()}
}
\concept{regularize}
