% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaps.R
\name{has_irregulars}
\alias{has_irregulars}
\title{Does a dataset have irregular data}
\usage{
has_irregulars(dataset, Datetime.colname = Datetime, epoch = "dominant.epoch")
}
\arguments{
\item{dataset}{A light logger dataset. Needs to be a dataframe.}

\item{Datetime.colname}{The column that contains the datetime. Needs to be a
\code{POSIXct} and part of the dataset.}

\item{epoch}{The epoch to use for the gapless sequence. Can be either a
\code{lubridate::duration()} or a string. If it is a string, it needs to be
either '"dominant.epoch"' (the default) for a guess based on the data or a
valid \code{lubridate::duration()} string, e.g., \code{"1 day"} or \code{"10 sec"}.}
}
\value{
logical
}
\description{
Returns \code{TRUE} if there are irregular data in the dataset and \code{FALSE} if not.
Irregular data can make sense if two datasets within a single group are
shifted to one another, e.g., if it contains data from two separate recording
sessions. The second session will be unlikely to have started at the exact
interval timing of the first session. While this is not problematic in itself, it is
still recommended to rectify the Datetimes to a common timestamp if time
precision permits it, e.g., through \code{\link[=aggregate_Datetime]{aggregate_Datetime()}} or
\code{\link[=cut_Datetime]{cut_Datetime()}}.
}
\examples{
#the sample dataset does not have any irregular data
sample.data.environment |> has_irregulars()

#even removing some data does not make it irregular, as all the Datetimes
#still fall in the regular interval
sample.data.environment |> dplyr::filter(MEDI <= 50000) |> has_irregulars()

#shifting some of the data will create irregular data
sample.data.environment |> 
  dplyr::mutate(
   Datetime = dplyr::if_else(
     sample(c(TRUE, FALSE), dplyr::n(), replace = TRUE), Datetime, Datetime + 1
     )
   ) |> 
   has_irregulars()
}
\seealso{
Other regularize: 
\code{\link{dominant_epoch}()},
\code{\link{extract_gaps}()},
\code{\link{gap_finder}()},
\code{\link{gap_handler}()},
\code{\link{gapless_Datetimes}()},
\code{\link{has_gaps}()}
}
\concept{regularize}
